@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The ssh username, password, and ssh public key.
 * @property password The password.
 * @property sshProfile The SSH profile.
 * @property username The username.
 */
public data class LinuxOperatingSystemProfileResponse(
    public val password: String? = null,
    public val sshProfile: SshProfileResponse? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.LinuxOperatingSystemProfileResponse): LinuxOperatingSystemProfileResponse = LinuxOperatingSystemProfileResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            sshProfile = javaType.sshProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.SshProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
