@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private endpoint connection.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property linkIdentifier The link identifier.
 * @property name The name of the resource
 * @property privateEndpoint The private endpoint of the private endpoint connection
 * @property privateLinkServiceConnectionState The private link service connection state.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class PrivateEndpointConnectionResponse(
    public val id: String,
    public val linkIdentifier: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.PrivateEndpointConnectionResponse): PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            id = javaType.id(),
            linkIdentifier = javaType.linkIdentifier(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
