@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The private link configuration.
 * @property groupId The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'.
 * @property id The private link configuration id.
 * @property ipConfigurations The IP configurations for the private link service.
 * @property name The name of private link configuration.
 * @property provisioningState The private link configuration provisioning state, which only appears in the response.
 * @property type The type of the private link configuration.
 */
public data class PrivateLinkConfigurationResponse(
    public val groupId: String,
    public val id: String,
    public val ipConfigurations: List<IPConfigurationResponse>,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.PrivateLinkConfigurationResponse): PrivateLinkConfigurationResponse = PrivateLinkConfigurationResponse(
            groupId = javaType.groupId(),
            id = javaType.id(),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
