@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private link service connection state.
 * @property actionsRequired Whether there is further actions.
 * @property description The optional description of the status.
 * @property status The concrete private link service connection.
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.PrivateLinkServiceConnectionStateResponse): PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
