@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a role on the cluster.
 * @property autoscaleConfiguration The autoscale configurations.
 * @property dataDisksGroups The data disks groups for the role.
 * @property encryptDataDisks Indicates whether encrypt the data disks.
 * @property hardwareProfile The hardware profile.
 * @property minInstanceCount The minimum instance count of the cluster.
 * @property name The name of the role.
 * @property osProfile The operating system profile.
 * @property scriptActions The list of script actions on the role.
 * @property targetInstanceCount The instance count of the cluster.
 * @property vMGroupName The name of the virtual machine group.
 * @property virtualNetworkProfile The virtual network profile.
 */
public data class RoleResponse(
    public val autoscaleConfiguration: AutoscaleResponse? = null,
    public val dataDisksGroups: List<DataDisksGroupsResponse>? = null,
    public val encryptDataDisks: Boolean? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val minInstanceCount: Int? = null,
    public val name: String? = null,
    public val osProfile: OsProfileResponse? = null,
    public val scriptActions: List<ScriptActionResponse>? = null,
    public val targetInstanceCount: Int? = null,
    public val vMGroupName: String? = null,
    public val virtualNetworkProfile: VirtualNetworkProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.RoleResponse): RoleResponse = RoleResponse(
            autoscaleConfiguration = javaType.autoscaleConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.AutoscaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataDisksGroups = javaType.dataDisksGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.DataDisksGroupsResponse.Companion.toKotlin(args0)
                })
            }),
            encryptDataDisks = javaType.encryptDataDisks().map({ args0 -> args0 }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            minInstanceCount = javaType.minInstanceCount().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.OsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scriptActions = javaType.scriptActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ScriptActionResponse.Companion.toKotlin(args0)
                })
            }),
            targetInstanceCount = javaType.targetInstanceCount().map({ args0 -> args0 }).orElse(null),
            vMGroupName = javaType.vMGroupName().map({ args0 -> args0 }).orElse(null),
            virtualNetworkProfile = javaType.virtualNetworkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.VirtualNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
