@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a script action on a running cluster.
 * @property applicationName The application name of the script action, if any.
 * @property name The name of the script action.
 * @property parameters The parameters for the script
 * @property roles The list of roles where script will be executed.
 * @property uri The URI to the script.
 */
public data class RuntimeScriptActionResponse(
    public val applicationName: String,
    public val name: String,
    public val parameters: String? = null,
    public val roles: List<String>,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.RuntimeScriptActionResponse): RuntimeScriptActionResponse = RuntimeScriptActionResponse(
            applicationName = javaType.applicationName(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 -> args0 }),
            uri = javaType.uri(),
        )
    }
}
