@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a script action on role on the cluster.
 * @property name The name of the script action.
 * @property parameters The parameters for the script provided.
 * @property uri The URI to the script.
 */
public data class ScriptActionResponse(
    public val name: String,
    public val parameters: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ScriptActionResponse): ScriptActionResponse = ScriptActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters(),
            uri = javaType.uri(),
        )
    }
}
