@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin

import com.pulumi.azurenative.healthbot.HealthbotFunctions.getBotPlain
import com.pulumi.azurenative.healthbot.HealthbotFunctions.listBotSecretsPlain
import com.pulumi.azurenative.healthbot.kotlin.inputs.GetBotPlainArgs
import com.pulumi.azurenative.healthbot.kotlin.inputs.GetBotPlainArgsBuilder
import com.pulumi.azurenative.healthbot.kotlin.inputs.ListBotSecretsPlainArgs
import com.pulumi.azurenative.healthbot.kotlin.inputs.ListBotSecretsPlainArgsBuilder
import com.pulumi.azurenative.healthbot.kotlin.outputs.GetBotResult
import com.pulumi.azurenative.healthbot.kotlin.outputs.ListBotSecretsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.healthbot.kotlin.outputs.GetBotResult.Companion.toKotlin as getBotResultToKotlin
import com.pulumi.azurenative.healthbot.kotlin.outputs.ListBotSecretsResult.Companion.toKotlin as listBotSecretsResultToKotlin

public object HealthbotFunctions {
    /**
     * Get a HealthBot.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-12-08-preview.
     * @param argument null
     * @return Azure Health Bot resource definition
     */
    public suspend fun getBot(argument: GetBotPlainArgs): GetBotResult =
        getBotResultToKotlin(getBotPlain(argument.toJava()).await())

    /**
     * @see [getBot].
     * @param botName The name of the Bot resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @return Azure Health Bot resource definition
     */
    public suspend fun getBot(botName: String, resourceGroupName: String): GetBotResult {
        val argument = GetBotPlainArgs(
            botName = botName,
            resourceGroupName = resourceGroupName,
        )
        return getBotResultToKotlin(getBotPlain(argument.toJava()).await())
    }

    /**
     * @see [getBot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthbot&#46;kotlin&#46;inputs&#46;GetBotPlainArgs].
     * @return Azure Health Bot resource definition
     */
    public suspend fun getBot(argument: suspend GetBotPlainArgsBuilder.() -> Unit): GetBotResult {
        val builder = GetBotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotResultToKotlin(getBotPlain(builtArgument.toJava()).await())
    }

    /**
     * List all secrets of a HealthBot.
     * Azure REST API version: 2023-05-01.
     * @param argument null
     * @return Health Bot Keys Response.
     */
    public suspend fun listBotSecrets(argument: ListBotSecretsPlainArgs): ListBotSecretsResult =
        listBotSecretsResultToKotlin(listBotSecretsPlain(argument.toJava()).await())

    /**
     * @see [listBotSecrets].
     * @param botName The name of the Bot resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @return Health Bot Keys Response.
     */
    public suspend fun listBotSecrets(botName: String, resourceGroupName: String): ListBotSecretsResult {
        val argument = ListBotSecretsPlainArgs(
            botName = botName,
            resourceGroupName = resourceGroupName,
        )
        return listBotSecretsResultToKotlin(listBotSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listBotSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthbot&#46;kotlin&#46;inputs&#46;ListBotSecretsPlainArgs].
     * @return Health Bot Keys Response.
     */
    public suspend fun listBotSecrets(argument: suspend ListBotSecretsPlainArgsBuilder.() -> Unit): ListBotSecretsResult {
        val builder = ListBotSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBotSecretsResultToKotlin(listBotSecretsPlain(builtArgument.toJava()).await())
    }
}
