@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the Azure Health Bot
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.healthbot.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.healthbot.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.healthbot.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.healthbot.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.healthbot.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.healthbot.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthbot.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
