@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.inputs

import com.pulumi.azurenative.healthbot.inputs.SkuArgs.builder
import com.pulumi.azurenative.healthbot.kotlin.enums.SkuName
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource model definition representing SKU
 * @property name The name of the Azure Health Bot SKU
 */
public data class SkuArgs(
    public val name: Output<SkuName>,
) : ConvertibleToJava<com.pulumi.azurenative.healthbot.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.healthbot.inputs.SkuArgs =
        com.pulumi.azurenative.healthbot.inputs.SkuArgs.builder()
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<SkuName>? = null

    /**
     * @param value The name of the Azure Health Bot SKU
     */
    @JvmName("ncxcegdlvehuxlkk")
    public suspend fun name(`value`: Output<SkuName>) {
        this.name = value
    }

    /**
     * @param value The name of the Azure Health Bot SKU
     */
    @JvmName("frqhwvtufpngawga")
    public suspend fun name(`value`: SkuName) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
