@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure Health Bot resource definition
 * @property id Fully qualified resource Id for the resource.
 * @property identity The identity of the Azure Health Bot.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property properties The set of properties specific to Azure Health Bot resource.
 * @property sku SKU of the Azure Health Bot.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetBotResult(
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: HealthBotPropertiesResponse,
    public val sku: SkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthbot.outputs.GetBotResult): GetBotResult = GetBotResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthbot.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.healthbot.kotlin.outputs.HealthBotPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.healthbot.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthbot.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
