@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the user assigned managed identity used by the Video Analyzer resource.
 * @property clientId The client ID of user assigned identity.
 * @property principalId The principal ID of user assigned identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthbot.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
