@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getAnalyticsConnectorPlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getDicomServicePlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getFhirServicePlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getIotConnectorFhirDestinationPlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getIotConnectorPlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getServicePlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getWorkspacePlain
import com.pulumi.azurenative.healthcareapis.HealthcareapisFunctions.getWorkspacePrivateEndpointConnectionPlain
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetAnalyticsConnectorPlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetAnalyticsConnectorPlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetDicomServicePlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetDicomServicePlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetFhirServicePlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetFhirServicePlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetIotConnectorFhirDestinationPlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetIotConnectorFhirDestinationPlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetIotConnectorPlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetIotConnectorPlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetWorkspacePrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.GetWorkspacePrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetAnalyticsConnectorResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetDicomServiceResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetFhirServiceResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetIotConnectorFhirDestinationResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetIotConnectorResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetWorkspacePrivateEndpointConnectionResult
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetAnalyticsConnectorResult.Companion.toKotlin as getAnalyticsConnectorResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetDicomServiceResult.Companion.toKotlin as getDicomServiceResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetFhirServiceResult.Companion.toKotlin as getFhirServiceResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetIotConnectorFhirDestinationResult.Companion.toKotlin as getIotConnectorFhirDestinationResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetIotConnectorResult.Companion.toKotlin as getIotConnectorResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetWorkspacePrivateEndpointConnectionResult.Companion.toKotlin as getWorkspacePrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object HealthcareapisFunctions {
    /**
     * Gets the properties of the specified Analytics Connector.
     * Azure REST API version: 2022-10-01-preview.
     * @param argument null
     * @return Analytics Connector definition.
     */
    public suspend fun getAnalyticsConnector(argument: GetAnalyticsConnectorPlainArgs): GetAnalyticsConnectorResult =
        getAnalyticsConnectorResultToKotlin(getAnalyticsConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAnalyticsConnector].
     * @param analyticsConnectorName The name of Analytics Connector resource.
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return Analytics Connector definition.
     */
    public suspend fun getAnalyticsConnector(
        analyticsConnectorName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetAnalyticsConnectorResult {
        val argument = GetAnalyticsConnectorPlainArgs(
            analyticsConnectorName = analyticsConnectorName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getAnalyticsConnectorResultToKotlin(getAnalyticsConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAnalyticsConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetAnalyticsConnectorPlainArgs].
     * @return Analytics Connector definition.
     */
    public suspend fun getAnalyticsConnector(argument: suspend GetAnalyticsConnectorPlainArgsBuilder.() -> Unit): GetAnalyticsConnectorResult {
        val builder = GetAnalyticsConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAnalyticsConnectorResultToKotlin(getAnalyticsConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified DICOM Service.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return The description of Dicom Service
     */
    public suspend fun getDicomService(argument: GetDicomServicePlainArgs): GetDicomServiceResult =
        getDicomServiceResultToKotlin(getDicomServicePlain(argument.toJava()).await())

    /**
     * @see [getDicomService].
     * @param dicomServiceName The name of DICOM Service resource.
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return The description of Dicom Service
     */
    public suspend fun getDicomService(
        dicomServiceName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDicomServiceResult {
        val argument = GetDicomServicePlainArgs(
            dicomServiceName = dicomServiceName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDicomServiceResultToKotlin(getDicomServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDicomService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetDicomServicePlainArgs].
     * @return The description of Dicom Service
     */
    public suspend fun getDicomService(argument: suspend GetDicomServicePlainArgsBuilder.() -> Unit): GetDicomServiceResult {
        val builder = GetDicomServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDicomServiceResultToKotlin(getDicomServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified FHIR Service.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return The description of Fhir Service
     */
    public suspend fun getFhirService(argument: GetFhirServicePlainArgs): GetFhirServiceResult =
        getFhirServiceResultToKotlin(getFhirServicePlain(argument.toJava()).await())

    /**
     * @see [getFhirService].
     * @param fhirServiceName The name of FHIR Service resource.
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return The description of Fhir Service
     */
    public suspend fun getFhirService(
        fhirServiceName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetFhirServiceResult {
        val argument = GetFhirServicePlainArgs(
            fhirServiceName = fhirServiceName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getFhirServiceResultToKotlin(getFhirServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getFhirService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetFhirServicePlainArgs].
     * @return The description of Fhir Service
     */
    public suspend fun getFhirService(argument: suspend GetFhirServicePlainArgsBuilder.() -> Unit): GetFhirServiceResult {
        val builder = GetFhirServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFhirServiceResultToKotlin(getFhirServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified IoT Connector.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return IoT Connector definition.
     */
    public suspend fun getIotConnector(argument: GetIotConnectorPlainArgs): GetIotConnectorResult =
        getIotConnectorResultToKotlin(getIotConnectorPlain(argument.toJava()).await())

    /**
     * @see [getIotConnector].
     * @param iotConnectorName The name of IoT Connector resource.
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return IoT Connector definition.
     */
    public suspend fun getIotConnector(
        iotConnectorName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIotConnectorResult {
        val argument = GetIotConnectorPlainArgs(
            iotConnectorName = iotConnectorName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIotConnectorResultToKotlin(getIotConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetIotConnectorPlainArgs].
     * @return IoT Connector definition.
     */
    public suspend fun getIotConnector(argument: suspend GetIotConnectorPlainArgsBuilder.() -> Unit): GetIotConnectorResult {
        val builder = GetIotConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotConnectorResultToKotlin(getIotConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified Iot Connector FHIR destination.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return IoT Connector FHIR destination definition.
     */
    public suspend fun getIotConnectorFhirDestination(argument: GetIotConnectorFhirDestinationPlainArgs): GetIotConnectorFhirDestinationResult =
        getIotConnectorFhirDestinationResultToKotlin(getIotConnectorFhirDestinationPlain(argument.toJava()).await())

    /**
     * @see [getIotConnectorFhirDestination].
     * @param fhirDestinationName The name of IoT Connector FHIR destination resource.
     * @param iotConnectorName The name of IoT Connector resource.
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return IoT Connector FHIR destination definition.
     */
    public suspend fun getIotConnectorFhirDestination(
        fhirDestinationName: String,
        iotConnectorName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIotConnectorFhirDestinationResult {
        val argument = GetIotConnectorFhirDestinationPlainArgs(
            fhirDestinationName = fhirDestinationName,
            iotConnectorName = iotConnectorName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIotConnectorFhirDestinationResultToKotlin(getIotConnectorFhirDestinationPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotConnectorFhirDestination].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetIotConnectorFhirDestinationPlainArgs].
     * @return IoT Connector FHIR destination definition.
     */
    public suspend fun getIotConnectorFhirDestination(argument: suspend GetIotConnectorFhirDestinationPlainArgsBuilder.() -> Unit): GetIotConnectorFhirDestinationResult {
        val builder = GetIotConnectorFhirDestinationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotConnectorFhirDestinationResultToKotlin(getIotConnectorFhirDestinationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a service instance.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2020-03-15, 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return The description of the service.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getService(resourceGroupName: String, resourceName: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return The description of the service.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified workspace.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return Workspace resource.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return Workspace resource.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Workspace resource.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit): GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the workspace.
     * Azure REST API version: 2023-02-28.
     * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getWorkspacePrivateEndpointConnection(argument: GetWorkspacePrivateEndpointConnectionPlainArgs): GetWorkspacePrivateEndpointConnectionResult =
        getWorkspacePrivateEndpointConnectionResultToKotlin(getWorkspacePrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getWorkspacePrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param workspaceName The name of workspace resource.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getWorkspacePrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetWorkspacePrivateEndpointConnectionResult {
        val argument = GetWorkspacePrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspacePrivateEndpointConnectionResultToKotlin(getWorkspacePrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspacePrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;healthcareapis&#46;kotlin&#46;inputs&#46;GetWorkspacePrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getWorkspacePrivateEndpointConnection(argument: suspend GetWorkspacePrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetWorkspacePrivateEndpointConnectionResult {
        val builder = GetWorkspacePrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspacePrivateEndpointConnectionResultToKotlin(getWorkspacePrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }
}
