@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse.Companion.toKotlin as iotMappingPropertiesResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IotConnectorFhirDestination].
 */
@PulumiTagMarker
public class IotConnectorFhirDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotConnectorFhirDestinationArgs = IotConnectorFhirDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotConnectorFhirDestinationArgsBuilder.() -> Unit) {
        val builder = IotConnectorFhirDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IotConnectorFhirDestination {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotConnectorFhirDestination(builtJavaResource)
    }
}

/**
 * IoT Connector FHIR destination definition.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
 * ## Example Usage
 * ### Create or update an Iot Connector FHIR destination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotConnectorFhirDestination = new AzureNative.HealthcareApis.IotConnectorFhirDestination("iotConnectorFhirDestination", new()
 *     {
 *         FhirDestinationName = "dest1",
 *         FhirMapping = new AzureNative.HealthcareApis.Inputs.IotMappingPropertiesArgs
 *         {
 *             Content = new Dictionary<string, object?>
 *             {
 *                 ["template"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["template"] = new Dictionary<string, object?>
 *                         {
 *                             ["codes"] = new[]
 *                             {
 *                                 new Dictionary<string, object?>
 *                                 {
 *                                     ["code"] = "8867-4",
 *                                     ["display"] = "Heart rate",
 *                                     ["system"] = "http://loinc.org",
 *                                 },
 *                             },
 *                             ["periodInterval"] = 60,
 *                             ["typeName"] = "heartrate",
 *                             ["value"] = new Dictionary<string, object?>
 *                             {
 *                                 ["defaultPeriod"] = 5000,
 *                                 ["unit"] = "count/min",
 *                                 ["valueName"] = "hr",
 *                                 ["valueType"] = "SampledData",
 *                             },
 *                         },
 *                         ["templateType"] = "CodeValueFhir",
 *                     },
 *                 },
 *                 ["templateType"] = "CollectionFhirTemplate",
 *             },
 *         },
 *         FhirServiceResourceId = "subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice",
 *         IotConnectorName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         ResourceIdentityResolutionType = AzureNative.HealthcareApis.IotIdentityResolutionType.Create,
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewIotConnectorFhirDestination(ctx, "iotConnectorFhirDestination", &healthcareapis.IotConnectorFhirDestinationArgs{
 * 			FhirDestinationName: pulumi.String("dest1"),
 * 			FhirMapping: &healthcareapis.IotMappingPropertiesArgs{
 * 				Content: pulumi.Any(map[string]interface{}{
 * 					"template": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"template": map[string]interface{}{
 * 								"codes": []map[string]interface{}{
 * 									map[string]interface{}{
 * 										"code":    "8867-4",
 * 										"display": "Heart rate",
 * 										"system":  "http://loinc.org",
 * 									},
 * 								},
 * 								"periodInterval": 60,
 * 								"typeName":       "heartrate",
 * 								"value": map[string]interface{}{
 * 									"defaultPeriod": 5000,
 * 									"unit":          "count/min",
 * 									"valueName":     "hr",
 * 									"valueType":     "SampledData",
 * 								},
 * 							},
 * 							"templateType": "CodeValueFhir",
 * 						},
 * 					},
 * 					"templateType": "CollectionFhirTemplate",
 * 				}),
 * 			},
 * 			FhirServiceResourceId:          pulumi.String("subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice"),
 * 			IotConnectorName:               pulumi.String("blue"),
 * 			Location:                       pulumi.String("westus"),
 * 			ResourceGroupName:              pulumi.String("testRG"),
 * 			ResourceIdentityResolutionType: pulumi.String(healthcareapis.IotIdentityResolutionTypeCreate),
 * 			WorkspaceName:                  pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotConnectorFhirDestination = new IotConnectorFhirDestination("iotConnectorFhirDestination", IotConnectorFhirDestinationArgs.builder()
 *             .fhirDestinationName("dest1")
 *             .fhirMapping(IotMappingPropertiesArgs.builder()
 *                 .content(Map.ofEntries(
 *                     Map.entry("template", Map.ofEntries(
 *                         Map.entry("template", Map.ofEntries(
 *                             Map.entry("codes", Map.ofEntries(
 *                                 Map.entry("code", "8867-4"),
 *                                 Map.entry("display", "Heart rate"),
 *                                 Map.entry("system", "http://loinc.org")
 *                             )),
 *                             Map.entry("periodInterval", 60),
 *                             Map.entry("typeName", "heartrate"),
 *                             Map.entry("value", Map.ofEntries(
 *                                 Map.entry("defaultPeriod", 5000),
 *                                 Map.entry("unit", "count/min"),
 *                                 Map.entry("valueName", "hr"),
 *                                 Map.entry("valueType", "SampledData")
 *                             ))
 *                         )),
 *                         Map.entry("templateType", "CodeValueFhir")
 *                     )),
 *                     Map.entry("templateType", "CollectionFhirTemplate")
 *                 ))
 *                 .build())
 *             .fhirServiceResourceId("subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice")
 *             .iotConnectorName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .resourceIdentityResolutionType("Create")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:IotConnectorFhirDestination dest1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}/fhirdestinations/{fhirDestinationName}
 * ```
 */
public class IotConnectorFhirDestination internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination,
) : KotlinCustomResource(javaResource, IotConnectorFhirDestinationMapper) {
    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * FHIR Mappings
     */
    public val fhirMapping: Output<IotMappingPropertiesResponse>
        get() = javaResource.fhirMapping().applyValue({ args0 ->
            args0.let({ args0 ->
                iotMappingPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Fully qualified resource id of the FHIR service to connect to.
     */
    public val fhirServiceResourceId: Output<String>
        get() = javaResource.fhirServiceResourceId().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines how resource identity is resolved on the destination.
     */
    public val resourceIdentityResolutionType: Output<String>
        get() = javaResource.resourceIdentityResolutionType().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotConnectorFhirDestinationMapper : ResourceMapper<IotConnectorFhirDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination::class == javaResource::class

    override fun map(javaResource: Resource): IotConnectorFhirDestination =
        IotConnectorFhirDestination(
            javaResource as
                com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination,
        )
}

/**
 * @see [IotConnectorFhirDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotConnectorFhirDestination].
 */
public suspend fun iotConnectorFhirDestination(
    name: String,
    block: suspend IotConnectorFhirDestinationResourceBuilder.() -> Unit,
): IotConnectorFhirDestination {
    val builder = IotConnectorFhirDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotConnectorFhirDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotConnectorFhirDestination(name: String): IotConnectorFhirDestination {
    val builder = IotConnectorFhirDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
