@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.IotIdentityResolutionType
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotMappingPropertiesArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.IotMappingPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IoT Connector FHIR destination definition.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
 * ## Example Usage
 * ### Create or update an Iot Connector FHIR destination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotConnectorFhirDestination = new AzureNative.HealthcareApis.IotConnectorFhirDestination("iotConnectorFhirDestination", new()
 *     {
 *         FhirDestinationName = "dest1",
 *         FhirMapping = new AzureNative.HealthcareApis.Inputs.IotMappingPropertiesArgs
 *         {
 *             Content = new Dictionary<string, object?>
 *             {
 *                 ["template"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["template"] = new Dictionary<string, object?>
 *                         {
 *                             ["codes"] = new[]
 *                             {
 *                                 new Dictionary<string, object?>
 *                                 {
 *                                     ["code"] = "8867-4",
 *                                     ["display"] = "Heart rate",
 *                                     ["system"] = "http://loinc.org",
 *                                 },
 *                             },
 *                             ["periodInterval"] = 60,
 *                             ["typeName"] = "heartrate",
 *                             ["value"] = new Dictionary<string, object?>
 *                             {
 *                                 ["defaultPeriod"] = 5000,
 *                                 ["unit"] = "count/min",
 *                                 ["valueName"] = "hr",
 *                                 ["valueType"] = "SampledData",
 *                             },
 *                         },
 *                         ["templateType"] = "CodeValueFhir",
 *                     },
 *                 },
 *                 ["templateType"] = "CollectionFhirTemplate",
 *             },
 *         },
 *         FhirServiceResourceId = "subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice",
 *         IotConnectorName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         ResourceIdentityResolutionType = AzureNative.HealthcareApis.IotIdentityResolutionType.Create,
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewIotConnectorFhirDestination(ctx, "iotConnectorFhirDestination", &healthcareapis.IotConnectorFhirDestinationArgs{
 * 			FhirDestinationName: pulumi.String("dest1"),
 * 			FhirMapping: &healthcareapis.IotMappingPropertiesArgs{
 * 				Content: pulumi.Any(map[string]interface{}{
 * 					"template": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"template": map[string]interface{}{
 * 								"codes": []map[string]interface{}{
 * 									map[string]interface{}{
 * 										"code":    "8867-4",
 * 										"display": "Heart rate",
 * 										"system":  "http://loinc.org",
 * 									},
 * 								},
 * 								"periodInterval": 60,
 * 								"typeName":       "heartrate",
 * 								"value": map[string]interface{}{
 * 									"defaultPeriod": 5000,
 * 									"unit":          "count/min",
 * 									"valueName":     "hr",
 * 									"valueType":     "SampledData",
 * 								},
 * 							},
 * 							"templateType": "CodeValueFhir",
 * 						},
 * 					},
 * 					"templateType": "CollectionFhirTemplate",
 * 				}),
 * 			},
 * 			FhirServiceResourceId:          pulumi.String("subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice"),
 * 			IotConnectorName:               pulumi.String("blue"),
 * 			Location:                       pulumi.String("westus"),
 * 			ResourceGroupName:              pulumi.String("testRG"),
 * 			ResourceIdentityResolutionType: pulumi.String(healthcareapis.IotIdentityResolutionTypeCreate),
 * 			WorkspaceName:                  pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestination;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotConnectorFhirDestination = new IotConnectorFhirDestination("iotConnectorFhirDestination", IotConnectorFhirDestinationArgs.builder()
 *             .fhirDestinationName("dest1")
 *             .fhirMapping(IotMappingPropertiesArgs.builder()
 *                 .content(Map.ofEntries(
 *                     Map.entry("template", Map.ofEntries(
 *                         Map.entry("template", Map.ofEntries(
 *                             Map.entry("codes", Map.ofEntries(
 *                                 Map.entry("code", "8867-4"),
 *                                 Map.entry("display", "Heart rate"),
 *                                 Map.entry("system", "http://loinc.org")
 *                             )),
 *                             Map.entry("periodInterval", 60),
 *                             Map.entry("typeName", "heartrate"),
 *                             Map.entry("value", Map.ofEntries(
 *                                 Map.entry("defaultPeriod", 5000),
 *                                 Map.entry("unit", "count/min"),
 *                                 Map.entry("valueName", "hr"),
 *                                 Map.entry("valueType", "SampledData")
 *                             ))
 *                         )),
 *                         Map.entry("templateType", "CodeValueFhir")
 *                     )),
 *                     Map.entry("templateType", "CollectionFhirTemplate")
 *                 ))
 *                 .build())
 *             .fhirServiceResourceId("subscriptions/11111111-2222-3333-4444-555566667777/resourceGroups/myrg/providers/Microsoft.HealthcareApis/workspaces/myworkspace/fhirservices/myfhirservice")
 *             .iotConnectorName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .resourceIdentityResolutionType("Create")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:IotConnectorFhirDestination dest1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}/fhirdestinations/{fhirDestinationName}
 * ```
 * @property fhirDestinationName The name of IoT Connector FHIR destination resource.
 * @property fhirMapping FHIR Mappings
 * @property fhirServiceResourceId Fully qualified resource id of the FHIR service to connect to.
 * @property iotConnectorName The name of IoT Connector resource.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceIdentityResolutionType Determines how resource identity is resolved on the destination.
 * @property workspaceName The name of workspace resource.
 */
public data class IotConnectorFhirDestinationArgs(
    public val fhirDestinationName: Output<String>? = null,
    public val fhirMapping: Output<IotMappingPropertiesArgs>? = null,
    public val fhirServiceResourceId: Output<String>? = null,
    public val iotConnectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceIdentityResolutionType: Output<Either<String, IotIdentityResolutionType>>? =
        null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs =
        com.pulumi.azurenative.healthcareapis.IotConnectorFhirDestinationArgs.builder()
            .fhirDestinationName(fhirDestinationName?.applyValue({ args0 -> args0 }))
            .fhirMapping(fhirMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fhirServiceResourceId(fhirServiceResourceId?.applyValue({ args0 -> args0 }))
            .iotConnectorName(iotConnectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceIdentityResolutionType(
                resourceIdentityResolutionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotConnectorFhirDestinationArgs].
 */
@PulumiTagMarker
public class IotConnectorFhirDestinationArgsBuilder internal constructor() {
    private var fhirDestinationName: Output<String>? = null

    private var fhirMapping: Output<IotMappingPropertiesArgs>? = null

    private var fhirServiceResourceId: Output<String>? = null

    private var iotConnectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceIdentityResolutionType: Output<Either<String, IotIdentityResolutionType>>? =
        null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of IoT Connector FHIR destination resource.
     */
    @JvmName("wixwkxjxiffcmfmb")
    public suspend fun fhirDestinationName(`value`: Output<String>) {
        this.fhirDestinationName = value
    }

    /**
     * @param value FHIR Mappings
     */
    @JvmName("kbbkkpjmgokcwevq")
    public suspend fun fhirMapping(`value`: Output<IotMappingPropertiesArgs>) {
        this.fhirMapping = value
    }

    /**
     * @param value Fully qualified resource id of the FHIR service to connect to.
     */
    @JvmName("iaimxbdircwdxfua")
    public suspend fun fhirServiceResourceId(`value`: Output<String>) {
        this.fhirServiceResourceId = value
    }

    /**
     * @param value The name of IoT Connector resource.
     */
    @JvmName("bkeapamipoaproih")
    public suspend fun iotConnectorName(`value`: Output<String>) {
        this.iotConnectorName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("bbngfuewrrdbxlax")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("nqsvonqbcktqvgau")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Determines how resource identity is resolved on the destination.
     */
    @JvmName("ootbelomrbqmtjau")
    public suspend fun resourceIdentityResolutionType(`value`: Output<Either<String, IotIdentityResolutionType>>) {
        this.resourceIdentityResolutionType = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("bpanlcsutgxvvyjc")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of IoT Connector FHIR destination resource.
     */
    @JvmName("bmurcljucgswhact")
    public suspend fun fhirDestinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fhirDestinationName = mapped
    }

    /**
     * @param value FHIR Mappings
     */
    @JvmName("dyifnupgicfpvhba")
    public suspend fun fhirMapping(`value`: IotMappingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fhirMapping = mapped
    }

    /**
     * @param argument FHIR Mappings
     */
    @JvmName("mewfmmvowcbrwfvb")
    public suspend fun fhirMapping(argument: suspend IotMappingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IotMappingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fhirMapping = mapped
    }

    /**
     * @param value Fully qualified resource id of the FHIR service to connect to.
     */
    @JvmName("qmasewnwvexxctya")
    public suspend fun fhirServiceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fhirServiceResourceId = mapped
    }

    /**
     * @param value The name of IoT Connector resource.
     */
    @JvmName("rxqyoxxtpyhbewvg")
    public suspend fun iotConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotConnectorName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("aeqqrybaleunstan")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("dfkwbyiaspjteiya")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Determines how resource identity is resolved on the destination.
     */
    @JvmName("ixxhxtavkeyrhqnr")
    public suspend fun resourceIdentityResolutionType(`value`: Either<String, IotIdentityResolutionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentityResolutionType = mapped
    }

    /**
     * @param value Determines how resource identity is resolved on the destination.
     */
    @JvmName("gnfoqedgyihsnwud")
    public fun resourceIdentityResolutionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IotIdentityResolutionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceIdentityResolutionType = mapped
    }

    /**
     * @param value Determines how resource identity is resolved on the destination.
     */
    @JvmName("alicvcplweiailns")
    public fun resourceIdentityResolutionType(`value`: IotIdentityResolutionType) {
        val toBeMapped = Either.ofRight<String, IotIdentityResolutionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceIdentityResolutionType = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("rdeolntxetgjwrvr")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IotConnectorFhirDestinationArgs = IotConnectorFhirDestinationArgs(
        fhirDestinationName = fhirDestinationName,
        fhirMapping = fhirMapping,
        fhirServiceResourceId = fhirServiceResourceId,
        iotConnectorName = iotConnectorName,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceIdentityResolutionType = resourceIdentityResolutionType,
        workspaceName = workspaceName,
    )
}
