@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServicesPropertiesResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServicesResourceResponseIdentity
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServicesPropertiesResponse.Companion.toKotlin as servicesPropertiesResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServicesResourceResponseIdentity.Companion.toKotlin as servicesResourceResponseIdentityToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.healthcareapis.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * The description of the service.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2020-03-15, 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
 * ## Example Usage
 * ### Create or Update a service with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.HealthcareApis.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.HealthcareApis.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Identity: &healthcareapis.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(healthcareapis.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &healthcareapis.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &healthcareapis.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Int(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &healthcareapis.ServiceCosmosDbConfigurationInfoArgs{
 * 					KeyVaultKeyUri:  pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput: pulumi.Int(1000),
 * 				},
 * 				ExportConfiguration: &healthcareapis.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: healthcareapis.PrivateEndpointConnectionTypeArray{},
 * 				PublicNetworkAccess:        pulumi.String(healthcareapis.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with all parameters and CMK enabled in a data sovereign region
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.HealthcareApis.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "Southeast Asia",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 CrossTenantCmkApplicationId = "de3fbeef-8c3a-428e-8b9f-4d229c8a85f4",
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.HealthcareApis.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Identity: &healthcareapis.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(healthcareapis.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("Southeast Asia"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &healthcareapis.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &healthcareapis.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Int(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &healthcareapis.ServiceCosmosDbConfigurationInfoArgs{
 * 					CrossTenantCmkApplicationId: pulumi.String("de3fbeef-8c3a-428e-8b9f-4d229c8a85f4"),
 * 					KeyVaultKeyUri:              pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput:             pulumi.Int(1000),
 * 				},
 * 				ExportConfiguration: &healthcareapis.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: healthcareapis.PrivateEndpointConnectionTypeArray{},
 * 				PublicNetworkAccess:        pulumi.String(healthcareapis.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("Southeast Asia")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .crossTenantCmkApplicationId("de3fbeef-8c3a-428e-8b9f-4d229c8a85f4")
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service2",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service2"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(ServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service2")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:Service service2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/services/{resourceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServicesResourceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    servicesResourceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of the service.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The common properties of a service.
     */
    public val properties: Output<ServicesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                servicesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.healthcareapis.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
