@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Controls how resources are versioned on the FHIR service
 */
public enum class FhirResourceVersionPolicy(
    public val javaValue: com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy> {
    Noversion(com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy.Noversion),
    Versioned(com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy.Versioned),
    Versionedupdate(com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy.Versionedupdate),
    ;

    override fun toJava(): com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.enums.FhirResourceVersionPolicy): FhirResourceVersionPolicy =
            FhirResourceVersionPolicy.values().first { it.javaValue == javaType }
    }
}
