@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorDataLakeDataDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Data Lake data destination for Analytics Connector.
 * @property dataLakeName The name for the Data Lake.
 * @property name Name of data destination.
 * @property type Type of data destination.
 * Expected value is 'datalake'.
 */
public data class AnalyticsConnectorDataLakeDataDestinationArgs(
    public val dataLakeName: Output<String>,
    public val name: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorDataLakeDataDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorDataLakeDataDestinationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorDataLakeDataDestinationArgs.builder()
            .dataLakeName(dataLakeName.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConnectorDataLakeDataDestinationArgs].
 */
@PulumiTagMarker
public class AnalyticsConnectorDataLakeDataDestinationArgsBuilder internal constructor() {
    private var dataLakeName: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name for the Data Lake.
     */
    @JvmName("ogqixbyvfvdqgoch")
    public suspend fun dataLakeName(`value`: Output<String>) {
        this.dataLakeName = value
    }

    /**
     * @param value Name of data destination.
     */
    @JvmName("rsrrvxotxpbnokax")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of data destination.
     * Expected value is 'datalake'.
     */
    @JvmName("gfcexdsspdiygctm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name for the Data Lake.
     */
    @JvmName("mugxaewqlucaxxxe")
    public suspend fun dataLakeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataLakeName = mapped
    }

    /**
     * @param value Name of data destination.
     */
    @JvmName("opaxtpddkpwsjdxb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of data destination.
     * Expected value is 'datalake'.
     */
    @JvmName("seapipbfeaodwwvt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AnalyticsConnectorDataLakeDataDestinationArgs =
        AnalyticsConnectorDataLakeDataDestinationArgs(
            dataLakeName = dataLakeName ?: throw PulumiNullFieldException("dataLakeName"),
            name = name,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
