@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.GetDicomServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dicomServiceName The name of DICOM Service resource.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property workspaceName The name of workspace resource.
 */
public data class GetDicomServicePlainArgs(
    public val dicomServiceName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.GetDicomServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.GetDicomServicePlainArgs =
        com.pulumi.azurenative.healthcareapis.inputs.GetDicomServicePlainArgs.builder()
            .dicomServiceName(dicomServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDicomServicePlainArgs].
 */
@PulumiTagMarker
public class GetDicomServicePlainArgsBuilder internal constructor() {
    private var dicomServiceName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of DICOM Service resource.
     */
    @JvmName("xgvfqsxxkpblgjjc")
    public suspend fun dicomServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dicomServiceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("udxjkcndhcxwjbma")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("dvibaeehpbbthqjx")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetDicomServicePlainArgs = GetDicomServicePlainArgs(
        dicomServiceName = dicomServiceName ?: throw PulumiNullFieldException("dicomServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
