@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 */
public data class GetServicePlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.healthcareapis.inputs.GetServicePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("wmbjovmffuveoxrf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("xtnfptdfkjheorqr")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
