@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ResourceVersionPolicyConfigurationArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.FhirResourceVersionPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The settings for history tracking for FHIR resources.
 * @property default The default value for tracking history across all resources.
 * @property resourceTypeOverrides A list of FHIR Resources and their version policy overrides.
 */
public data class ResourceVersionPolicyConfigurationArgs(
    public val default: Output<Either<String, FhirResourceVersionPolicy>>? = null,
    public val resourceTypeOverrides: Output<Map<String, Either<String, FhirResourceVersionPolicy>>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ResourceVersionPolicyConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.ResourceVersionPolicyConfigurationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ResourceVersionPolicyConfigurationArgs.builder()
            .default_(
                default?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceTypeOverrides(
                resourceTypeOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.transform({ args0 -> args0 }, { args0 ->
                                args0.let({ args0 ->
                                    args0.toJava()
                                })
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceVersionPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class ResourceVersionPolicyConfigurationArgsBuilder internal constructor() {
    private var default: Output<Either<String, FhirResourceVersionPolicy>>? = null

    private var resourceTypeOverrides: Output<Map<String, Either<String, FhirResourceVersionPolicy>>>? =
        null

    /**
     * @param value The default value for tracking history across all resources.
     */
    @JvmName("okfvtmajatomiils")
    public suspend fun default(`value`: Output<Either<String, FhirResourceVersionPolicy>>) {
        this.default = value
    }

    /**
     * @param value A list of FHIR Resources and their version policy overrides.
     */
    @JvmName("lcildgiahysikudk")
    public suspend fun resourceTypeOverrides(`value`: Output<Map<String, Either<String, FhirResourceVersionPolicy>>>) {
        this.resourceTypeOverrides = value
    }

    /**
     * @param value The default value for tracking history across all resources.
     */
    @JvmName("tksodhfivsgbyyhl")
    public suspend fun default(`value`: Either<String, FhirResourceVersionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The default value for tracking history across all resources.
     */
    @JvmName("peenvixqjhrituvw")
    public fun default(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FhirResourceVersionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The default value for tracking history across all resources.
     */
    @JvmName("abchxpspogubmigv")
    public fun default(`value`: FhirResourceVersionPolicy) {
        val toBeMapped = Either.ofRight<String, FhirResourceVersionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value A list of FHIR Resources and their version policy overrides.
     */
    @JvmName("bpkwjdrivdxvqrtc")
    public suspend fun resourceTypeOverrides(`value`: Map<String, Either<String, FhirResourceVersionPolicy>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeOverrides = mapped
    }

    /**
     * @param values A list of FHIR Resources and their version policy overrides.
     */
    @JvmName("xmfohwssunjtjkag")
    public fun resourceTypeOverrides(vararg values: Pair<String, Either<String, FhirResourceVersionPolicy>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeOverrides = mapped
    }

    internal fun build(): ResourceVersionPolicyConfigurationArgs =
        ResourceVersionPolicyConfigurationArgs(
            default = default,
            resourceTypeOverrides = resourceTypeOverrides,
        )
}
