@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Export operation configuration information
 * @property storageAccountName The name of the default export storage account.
 */
public data class ServiceExportConfigurationInfoArgs(
    public val storageAccountName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs.builder()
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceExportConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceExportConfigurationInfoArgsBuilder internal constructor() {
    private var storageAccountName: Output<String>? = null

    /**
     * @param value The name of the default export storage account.
     */
    @JvmName("tcroygdjuukhootb")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The name of the default export storage account.
     */
    @JvmName("tsxfjeptqtboamyi")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): ServiceExportConfigurationInfoArgs = ServiceExportConfigurationInfoArgs(
        storageAccountName = storageAccountName,
    )
}
