@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Data Lake data destination for Analytics Connector.
 * @property dataLakeName The name for the Data Lake.
 * @property name Name of data destination.
 * @property type Type of data destination.
 * Expected value is 'datalake'.
 */
public data class AnalyticsConnectorDataLakeDataDestinationResponse(
    public val dataLakeName: String,
    public val name: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.AnalyticsConnectorDataLakeDataDestinationResponse): AnalyticsConnectorDataLakeDataDestinationResponse =
            AnalyticsConnectorDataLakeDataDestinationResponse(
                dataLakeName = javaType.dataLakeName(),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
