@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Authentication configuration information
 * @property audiences The audiences for the service
 * @property authority The authority url for the service
 */
public data class DicomServiceAuthenticationConfigurationResponse(
    public val audiences: List<String>,
    public val authority: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.DicomServiceAuthenticationConfigurationResponse): DicomServiceAuthenticationConfigurationResponse =
            DicomServiceAuthenticationConfigurationResponse(
                audiences = javaType.audiences().map({ args0 -> args0 }),
                authority = javaType.authority(),
            )
    }
}
