@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Authentication configuration information
 * @property audience The audience url for the service
 * @property authority The authority url for the service
 * @property smartProxyEnabled If the SMART on FHIR proxy is enabled
 */
public data class FhirServiceAuthenticationConfigurationResponse(
    public val audience: String? = null,
    public val authority: String? = null,
    public val smartProxyEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.FhirServiceAuthenticationConfigurationResponse): FhirServiceAuthenticationConfigurationResponse =
            FhirServiceAuthenticationConfigurationResponse(
                audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
                authority = javaType.authority().map({ args0 -> args0 }).orElse(null),
                smartProxyEnabled = javaType.smartProxyEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
