@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The description of Dicom Service
 * @property authenticationConfiguration Dicom Service authentication configuration.
 * @property corsConfiguration Dicom Service Cors configuration.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property eventState DICOM Service event support status.
 * @property id The resource identifier.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property location The resource location.
 * @property name The resource name.
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 * @property serviceUrl The url of the Dicom Services.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The resource type.
 */
public data class GetDicomServiceResult(
    public val authenticationConfiguration: DicomServiceAuthenticationConfigurationResponse? = null,
    public val corsConfiguration: CorsConfigurationResponse? = null,
    public val etag: String? = null,
    public val eventState: String,
    public val id: String,
    public val identity: ServiceManagedIdentityResponseIdentity? = null,
    public val location: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String,
    public val serviceUrl: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetDicomServiceResult): GetDicomServiceResult = GetDicomServiceResult(
            authenticationConfiguration = javaType.authenticationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.DicomServiceAuthenticationConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            corsConfiguration = javaType.corsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.CorsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            eventState = javaType.eventState(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess(),
            serviceUrl = javaType.serviceUrl(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
