@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The settings for history tracking for FHIR resources.
 * @property default The default value for tracking history across all resources.
 * @property resourceTypeOverrides A list of FHIR Resources and their version policy overrides.
 */
public data class ResourceVersionPolicyConfigurationResponse(
    public val default: String? = null,
    public val resourceTypeOverrides: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ResourceVersionPolicyConfigurationResponse): ResourceVersionPolicyConfigurationResponse = ResourceVersionPolicyConfigurationResponse(
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            resourceTypeOverrides = javaType.resourceTypeOverrides().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
