@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure container registry configuration information
 * @property loginServers The list of the ACR login servers.
 * @property ociArtifacts The list of Open Container Initiative (OCI) artifacts.
 */
public data class ServiceAcrConfigurationInfoResponse(
    public val loginServers: List<String>? = null,
    public val ociArtifacts: List<ServiceOciArtifactEntryResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServiceAcrConfigurationInfoResponse): ServiceAcrConfigurationInfoResponse = ServiceAcrConfigurationInfoResponse(
            loginServers = javaType.loginServers().map({ args0 -> args0 }),
            ociArtifacts = javaType.ociArtifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceOciArtifactEntryResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
