@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Import operation configuration information
 * @property enabled If the import operation is enabled.
 * @property initialImportMode If the FHIR service is in InitialImportMode.
 * @property integrationDataStore The name of the default integration storage account.
 */
public data class ServiceImportConfigurationInfoResponse(
    public val enabled: Boolean? = null,
    public val initialImportMode: Boolean? = null,
    public val integrationDataStore: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServiceImportConfigurationInfoResponse): ServiceImportConfigurationInfoResponse = ServiceImportConfigurationInfoResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            initialImportMode = javaType.initialImportMode().map({ args0 -> args0 }).orElse(null),
            integrationDataStore = javaType.integrationDataStore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
