@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Setting indicating whether the service has a managed identity associated with it.
 * @property principalId The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property type Type of identity being specified, currently SystemAssigned and None are allowed.
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class ServiceManagedIdentityResponseIdentity(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServiceManagedIdentityResponseIdentity): ServiceManagedIdentityResponseIdentity = ServiceManagedIdentityResponseIdentity(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.healthcareapis.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
