@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Open Container Initiative (OCI) artifact.
 * @property digest The artifact digest.
 * @property imageName The artifact name.
 * @property loginServer The Azure Container Registry login server.
 */
public data class ServiceOciArtifactEntryResponse(
    public val digest: String? = null,
    public val imageName: String? = null,
    public val loginServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServiceOciArtifactEntryResponse): ServiceOciArtifactEntryResponse = ServiceOciArtifactEntryResponse(
            digest = javaType.digest().map({ args0 -> args0 }).orElse(null),
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            loginServer = javaType.loginServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
