@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Setting indicating whether the service has a managed identity associated with it.
 * @property principalId The principal ID of the resource identity.
 * @property tenantId The tenant ID of the resource.
 * @property type Type of identity being specified, currently SystemAssigned and None are allowed.
 */
public data class ServicesResourceResponseIdentity(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.ServicesResourceResponseIdentity): ServicesResourceResponseIdentity = ServicesResourceResponseIdentity(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
