@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Workspaces resource specific properties.
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 */
public data class WorkspaceResponseProperties(
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.WorkspaceResponseProperties): WorkspaceResponseProperties = WorkspaceResponseProperties(
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess(),
        )
    }
}
