@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin

import com.pulumi.azurenative.hybridcloud.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudConnection].
 */
@PulumiTagMarker
public class CloudConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudConnectionArgs = CloudConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudConnectionArgsBuilder.() -> Unit) {
        val builder = CloudConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudConnection {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcloud.CloudConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudConnection(builtJavaResource)
    }
}

/**
 * Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2023-01-01-preview.
 * ## Example Usage
 * ### Create a Cloud Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudConnection = new AzureNative.HybridCloud.CloudConnection("cloudConnection", new()
 *     {
 *         CloudConnectionName = "cloudconnection1",
 *         CloudConnector = new AzureNative.HybridCloud.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012",
 *         },
 *         Location = "West US",
 *         RemoteResourceId = "arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a",
 *         ResourceGroupName = "demo-rg",
 *         SharedKey = "password123",
 *         VirtualHub = new AzureNative.HybridCloud.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcloud.NewCloudConnection(ctx, "cloudConnection", &hybridcloud.CloudConnectionArgs{
 * 			CloudConnectionName: pulumi.String("cloudconnection1"),
 * 			CloudConnector: &hybridcloud.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			RemoteResourceId:  pulumi.String("arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a"),
 * 			ResourceGroupName: pulumi.String("demo-rg"),
 * 			SharedKey:         pulumi.String("password123"),
 * 			VirtualHub: &hybridcloud.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcloud.CloudConnection;
 * import com.pulumi.azurenative.hybridcloud.CloudConnectionArgs;
 * import com.pulumi.azurenative.hybridcloud.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudConnection = new CloudConnection("cloudConnection", CloudConnectionArgs.builder()
 *             .cloudConnectionName("cloudconnection1")
 *             .cloudConnector(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012")
 *                 .build())
 *             .location("West US")
 *             .remoteResourceId("arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a")
 *             .resourceGroupName("demo-rg")
 *             .sharedKey("password123")
 *             .virtualHub(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcloud:CloudConnection cloudconnection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCloud/cloudConnections/{cloudConnectionName}
 * ```
 */
public class CloudConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcloud.CloudConnection,
) : KotlinCustomResource(javaResource, CloudConnectionMapper) {
    /**
     * The cloud connector which discovered the remote resource.
     */
    public val cloudConnector: Output<ResourceReferenceResponse>?
        get() = javaResource.cloudConnector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the cloud collection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Identifier for the remote cloud resource
     */
    public val remoteResourceId: Output<String>?
        get() = javaResource.remoteResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Shared key of the cloud connection.
     */
    public val sharedKey: Output<String>?
        get() = javaResource.sharedKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The virtualHub to which the cloud connection belongs.
     */
    public val virtualHub: Output<ResourceReferenceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceReferenceResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object CloudConnectionMapper : ResourceMapper<CloudConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcloud.CloudConnection::class == javaResource::class

    override fun map(javaResource: Resource): CloudConnection = CloudConnection(
        javaResource as
            com.pulumi.azurenative.hybridcloud.CloudConnection,
    )
}

/**
 * @see [CloudConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudConnection].
 */
public suspend fun cloudConnection(
    name: String,
    block: suspend CloudConnectionResourceBuilder.() -> Unit,
): CloudConnection {
    val builder = CloudConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudConnection(name: String): CloudConnection {
    val builder = CloudConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
