@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin

import com.pulumi.azurenative.hybridcloud.HybridcloudFunctions.getCloudConnectionPlain
import com.pulumi.azurenative.hybridcloud.HybridcloudFunctions.getCloudConnectorPlain
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.GetCloudConnectionPlainArgs
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.GetCloudConnectionPlainArgsBuilder
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.GetCloudConnectorPlainArgs
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.GetCloudConnectorPlainArgsBuilder
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.GetCloudConnectionResult
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.GetCloudConnectorResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.GetCloudConnectionResult.Companion.toKotlin as getCloudConnectionResultToKotlin
import com.pulumi.azurenative.hybridcloud.kotlin.outputs.GetCloudConnectorResult.Companion.toKotlin as getCloudConnectorResultToKotlin

public object HybridcloudFunctions {
    /**
     * Gets the specified cloud connection in a specified resource group.
     * Azure REST API version: 2023-01-01-preview.
     * @param argument null
     * @return Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
     */
    public suspend fun getCloudConnection(argument: GetCloudConnectionPlainArgs): GetCloudConnectionResult =
        getCloudConnectionResultToKotlin(getCloudConnectionPlain(argument.toJava()).await())

    /**
     * @see [getCloudConnection].
     * @param cloudConnectionName The name of the cloud connection resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
     */
    public suspend fun getCloudConnection(cloudConnectionName: String, resourceGroupName: String): GetCloudConnectionResult {
        val argument = GetCloudConnectionPlainArgs(
            cloudConnectionName = cloudConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudConnectionResultToKotlin(getCloudConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcloud&#46;kotlin&#46;inputs&#46;GetCloudConnectionPlainArgs].
     * @return Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
     */
    public suspend fun getCloudConnection(argument: suspend GetCloudConnectionPlainArgsBuilder.() -> Unit): GetCloudConnectionResult {
        val builder = GetCloudConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudConnectionResultToKotlin(getCloudConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified cloud connector in a specified resource group.
     * Azure REST API version: 2023-01-01-preview.
     * @param argument null
     * @return Cloud Connector resource.
     */
    public suspend fun getCloudConnector(argument: GetCloudConnectorPlainArgs): GetCloudConnectorResult =
        getCloudConnectorResultToKotlin(getCloudConnectorPlain(argument.toJava()).await())

    /**
     * @see [getCloudConnector].
     * @param cloudConnectorName The name of the cloud connector resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Cloud Connector resource.
     */
    public suspend fun getCloudConnector(cloudConnectorName: String, resourceGroupName: String): GetCloudConnectorResult {
        val argument = GetCloudConnectorPlainArgs(
            cloudConnectorName = cloudConnectorName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudConnectorResultToKotlin(getCloudConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hybridcloud&#46;kotlin&#46;inputs&#46;GetCloudConnectorPlainArgs].
     * @return Cloud Connector resource.
     */
    public suspend fun getCloudConnector(argument: suspend GetCloudConnectorPlainArgsBuilder.() -> Unit): GetCloudConnectorResult {
        val builder = GetCloudConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudConnectorResultToKotlin(getCloudConnectorPlain(builtArgument.toJava()).await())
    }
}
