@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
 * @property cloudConnector The cloud connector which discovered the remote resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the cloud collection resource.
 * @property remoteResourceId Identifier for the remote cloud resource
 * @property sharedKey Shared key of the cloud connection.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualHub The virtualHub to which the cloud connection belongs.
 */
public data class GetCloudConnectionResult(
    public val cloudConnector: ResourceReferenceResponse? = null,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val remoteResourceId: String? = null,
    public val sharedKey: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: ResourceReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcloud.outputs.GetCloudConnectionResult): GetCloudConnectionResult = GetCloudConnectionResult(
            cloudConnector = javaType.cloudConnector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcloud.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            remoteResourceId = javaType.remoteResourceId().map({ args0 -> args0 }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcloud.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
