@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.GatewayArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.GatewayType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes an Arc Gateway.
 * Azure REST API version: 2024-03-31-preview.
 * Other available API versions: 2024-05-20-preview.
 * ## Example Usage
 * ### Create or Update a Gateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.HybridCompute.Gateway("gateway", new()
 *     {
 *         AllowedFeatures = new[]
 *         {
 *             "*",
 *         },
 *         GatewayName = "{gatewayName}",
 *         GatewayType = AzureNative.HybridCompute.GatewayType.Public,
 *         Location = "eastus2euap",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewGateway(ctx, "gateway", &hybridcompute.GatewayArgs{
 * 			AllowedFeatures: pulumi.StringArray{
 * 				pulumi.String("*"),
 * 			},
 * 			GatewayName:       pulumi.String("{gatewayName}"),
 * 			GatewayType:       pulumi.String(hybridcompute.GatewayTypePublic),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.Gateway;
 * import com.pulumi.azurenative.hybridcompute.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .allowedFeatures("*")
 *             .gatewayName("{gatewayName}")
 *             .gatewayType("Public")
 *             .location("eastus2euap")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:Gateway {gatewayName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/gateways/{gatewayName}
 * ```
 * @property allowedFeatures Specifies the list of features that are enabled for this Gateway.
 * @property gatewayName The name of the Gateway.
 * @property gatewayType The type of the Gateway resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class GatewayArgs(
    public val allowedFeatures: Output<List<String>>? = null,
    public val gatewayName: Output<String>? = null,
    public val gatewayType: Output<Either<String, GatewayType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.GatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.GatewayArgs =
        com.pulumi.azurenative.hybridcompute.GatewayArgs.builder()
            .allowedFeatures(allowedFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .gatewayType(
                gatewayType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var allowedFeatures: Output<List<String>>? = null

    private var gatewayName: Output<String>? = null

    private var gatewayType: Output<Either<String, GatewayType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the list of features that are enabled for this Gateway.
     */
    @JvmName("cwgpexnhiytemmbk")
    public suspend fun allowedFeatures(`value`: Output<List<String>>) {
        this.allowedFeatures = value
    }

    @JvmName("rcsjmpepqgxmrvyh")
    public suspend fun allowedFeatures(vararg values: Output<String>) {
        this.allowedFeatures = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of features that are enabled for this Gateway.
     */
    @JvmName("qdlglxlcqdvautqs")
    public suspend fun allowedFeatures(values: List<Output<String>>) {
        this.allowedFeatures = Output.all(values)
    }

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("jhertaojafttqgrs")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value The type of the Gateway resource.
     */
    @JvmName("nglramqkluivawmq")
    public suspend fun gatewayType(`value`: Output<Either<String, GatewayType>>) {
        this.gatewayType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("twtuouxgbopbfrdp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("clyccjgwveqnuoea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bdydppnflqqxmlrw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the list of features that are enabled for this Gateway.
     */
    @JvmName("jskiualqpossojox")
    public suspend fun allowedFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedFeatures = mapped
    }

    /**
     * @param values Specifies the list of features that are enabled for this Gateway.
     */
    @JvmName("yuuweofqaqkyhony")
    public suspend fun allowedFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedFeatures = mapped
    }

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("emererurbtmumvpv")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value The type of the Gateway resource.
     */
    @JvmName("qdyqriwtfafgtths")
    public suspend fun gatewayType(`value`: Either<String, GatewayType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of the Gateway resource.
     */
    @JvmName("judohihqwlgexxqa")
    public fun gatewayType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of the Gateway resource.
     */
    @JvmName("ctmymtomexeiejjr")
    public fun gatewayType(`value`: GatewayType) {
        val toBeMapped = Either.ofRight<String, GatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tvmmsljueoaiwdcd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qyltqoxjobbecray")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rhlltibnbplbjtcp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("euxfpoggrjqnqmtd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        allowedFeatures = allowedFeatures,
        gatewayName = gatewayName,
        gatewayType = gatewayType,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
