@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.LicenseProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a license profile in a hybrid machine.
 * Azure REST API version: 2023-06-20-preview.
 * Other available API versions: 2023-10-03-preview, 2024-03-31-preview, 2024-05-20-preview.
 * ## Example Usage
 * ### Create or Update a License Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var licenseProfile = new AzureNative.HybridCompute.LicenseProfile("licenseProfile", new()
 *     {
 *         AssignedLicense = "{LicenseResourceId}",
 *         LicenseProfileName = "default",
 *         Location = "eastus2euap",
 *         MachineName = "myMachine",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewLicenseProfile(ctx, "licenseProfile", &hybridcompute.LicenseProfileArgs{
 * 			AssignedLicense:    pulumi.String("{LicenseResourceId}"),
 * 			LicenseProfileName: pulumi.String("default"),
 * 			Location:           pulumi.String("eastus2euap"),
 * 			MachineName:        pulumi.String("myMachine"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.LicenseProfile;
 * import com.pulumi.azurenative.hybridcompute.LicenseProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var licenseProfile = new LicenseProfile("licenseProfile", LicenseProfileArgs.builder()
 *             .assignedLicense("{LicenseResourceId}")
 *             .licenseProfileName("default")
 *             .location("eastus2euap")
 *             .machineName("myMachine")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:LicenseProfile default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/licenseProfiles/{licenseProfileName}
 * ```
 * @property assignedLicense The resource id of the license.
 * @property licenseProfileName The name of the license profile.
 * @property location The geo-location where the resource lives
 * @property machineName The name of the hybrid machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class LicenseProfileArgs(
    public val assignedLicense: Output<String>? = null,
    public val licenseProfileName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.LicenseProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.LicenseProfileArgs =
        com.pulumi.azurenative.hybridcompute.LicenseProfileArgs.builder()
            .assignedLicense(assignedLicense?.applyValue({ args0 -> args0 }))
            .licenseProfileName(licenseProfileName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LicenseProfileArgs].
 */
@PulumiTagMarker
public class LicenseProfileArgsBuilder internal constructor() {
    private var assignedLicense: Output<String>? = null

    private var licenseProfileName: Output<String>? = null

    private var location: Output<String>? = null

    private var machineName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The resource id of the license.
     */
    @JvmName("hdgocfkjqkrjibqo")
    public suspend fun assignedLicense(`value`: Output<String>) {
        this.assignedLicense = value
    }

    /**
     * @param value The name of the license profile.
     */
    @JvmName("bgfiicrivcskfuyt")
    public suspend fun licenseProfileName(`value`: Output<String>) {
        this.licenseProfileName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dwnhgbyaufdeowdg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("hubjvimqpoydlwkm")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bypiksitpcsbhkom")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nvtxqpysnvlypkbr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource id of the license.
     */
    @JvmName("fivgbjxivkhdoxbl")
    public suspend fun assignedLicense(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedLicense = mapped
    }

    /**
     * @param value The name of the license profile.
     */
    @JvmName("ggvgslbdqtvhanuv")
    public suspend fun licenseProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseProfileName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sydknqdmovjghauq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("anolsvsxybqqvdai")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqgnccirmbihvkvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pqrnnlnypphkgoco")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("whhcyrrpoaqtegxp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LicenseProfileArgs = LicenseProfileArgs(
        assignedLicense = assignedLicense,
        licenseProfileName = licenseProfileName,
        location = location,
        machineName = machineName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
