@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineRunCommandInstanceViewResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineRunCommandScriptSourceResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.RunCommandInputParameterResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.RunCommandManagedIdentityResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineRunCommandInstanceViewResponse.Companion.toKotlin as machineRunCommandInstanceViewResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineRunCommandScriptSourceResponse.Companion.toKotlin as machineRunCommandScriptSourceResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.RunCommandInputParameterResponse.Companion.toKotlin as runCommandInputParameterResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.RunCommandManagedIdentityResponse.Companion.toKotlin as runCommandManagedIdentityResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MachineRunCommand].
 */
@PulumiTagMarker
public class MachineRunCommandResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineRunCommandArgs = MachineRunCommandArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineRunCommandArgsBuilder.() -> Unit) {
        val builder = MachineRunCommandArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MachineRunCommand {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcompute.MachineRunCommand(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineRunCommand(builtJavaResource)
    }
}

/**
 * Describes a Run Command
 * Azure REST API version: 2023-10-03-preview.
 * Other available API versions: 2024-03-31-preview, 2024-05-20-preview.
 * ## Example Usage
 * ### Create or Update a Run Command
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineRunCommand = new AzureNative.HybridCompute.MachineRunCommand("machineRunCommand", new()
 *     {
 *         AsyncExecution = false,
 *         ErrorBlobUri = "https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt",
 *         Location = "eastus2",
 *         MachineName = "myMachine",
 *         OutputBlobUri = "https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt",
 *         Parameters = new[]
 *         {
 *             new AzureNative.HybridCompute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param1",
 *                 Value = "value1",
 *             },
 *             new AzureNative.HybridCompute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param2",
 *                 Value = "value2",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RunAsPassword = "<runAsPassword>",
 *         RunAsUser = "user1",
 *         RunCommandName = "myRunCommand",
 *         Source = new AzureNative.HybridCompute.Inputs.MachineRunCommandScriptSourceArgs
 *         {
 *             Script = "Write-Host Hello World!",
 *         },
 *         TimeoutInSeconds = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachineRunCommand(ctx, "machineRunCommand", &hybridcompute.MachineRunCommandArgs{
 * 			AsyncExecution: pulumi.Bool(false),
 * 			ErrorBlobUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt"),
 * 			Location:       pulumi.String("eastus2"),
 * 			MachineName:    pulumi.String("myMachine"),
 * 			OutputBlobUri:  pulumi.String("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt"),
 * 			Parameters: hybridcompute.RunCommandInputParameterArray{
 * 				&hybridcompute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param1"),
 * 					Value: pulumi.String("value1"),
 * 				},
 * 				&hybridcompute.RunCommandInputParameterArgs{
 * 					Name:  pulumi.String("param2"),
 * 					Value: pulumi.String("value2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunAsPassword:     pulumi.String("<runAsPassword>"),
 * 			RunAsUser:         pulumi.String("user1"),
 * 			RunCommandName:    pulumi.String("myRunCommand"),
 * 			Source: &hybridcompute.MachineRunCommandScriptSourceArgs{
 * 				Script: pulumi.String("Write-Host Hello World!"),
 * 			},
 * 			TimeoutInSeconds: pulumi.Int(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.MachineRunCommand;
 * import com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.RunCommandInputParameterArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.MachineRunCommandScriptSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineRunCommand = new MachineRunCommand("machineRunCommand", MachineRunCommandArgs.builder()
 *             .asyncExecution(false)
 *             .errorBlobUri("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt")
 *             .location("eastus2")
 *             .machineName("myMachine")
 *             .outputBlobUri("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt")
 *             .parameters(
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param1")
 *                     .value("value1")
 *                     .build(),
 *                 RunCommandInputParameterArgs.builder()
 *                     .name("param2")
 *                     .value("value2")
 *                     .build())
 *             .resourceGroupName("myResourceGroup")
 *             .runAsPassword("<runAsPassword>")
 *             .runAsUser("user1")
 *             .runCommandName("myRunCommand")
 *             .source(MachineRunCommandScriptSourceArgs.builder()
 *                 .script("Write-Host Hello World!")
 *                 .build())
 *             .timeoutInSeconds(3600)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:MachineRunCommand myRunCommand /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/runCommands/{runCommandName}
 * ```
 */
public class MachineRunCommand internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.MachineRunCommand,
) : KotlinCustomResource(javaResource, MachineRunCommandMapper) {
    /**
     * Optional. If set to true, provisioning will complete as soon as script starts and will not wait for script to complete.
     */
    public val asyncExecution: Output<Boolean>?
        get() = javaResource.asyncExecution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    public val errorBlobManagedIdentity: Output<RunCommandManagedIdentityResponse>?
        get() = javaResource.errorBlobManagedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> runCommandManagedIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    public val errorBlobUri: Output<String>?
        get() = javaResource.errorBlobUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The machine run command instance view.
     */
    public val instanceView: Output<MachineRunCommandInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                machineRunCommandInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    public val outputBlobManagedIdentity: Output<RunCommandManagedIdentityResponse>?
        get() = javaResource.outputBlobManagedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> runCommandManagedIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    public val outputBlobUri: Output<String>?
        get() = javaResource.outputBlobUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameters used by the script.
     */
    public val parameters: Output<List<RunCommandInputParameterResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> runCommandInputParameterResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The parameters used by the script.
     */
    public val protectedParameters: Output<List<RunCommandInputParameterResponse>>?
        get() = javaResource.protectedParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        runCommandInputParameterResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies the user account password on the machine when executing the run command.
     */
    public val runAsPassword: Output<String>?
        get() = javaResource.runAsPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the user account on the machine when executing the run command.
     */
    public val runAsUser: Output<String>?
        get() = javaResource.runAsUser().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source of the run command script.
     */
    public val source: Output<MachineRunCommandScriptSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    machineRunCommandScriptSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The timeout in seconds to execute the run command.
     */
    public val timeoutInSeconds: Output<Int>?
        get() = javaResource.timeoutInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MachineRunCommandMapper : ResourceMapper<MachineRunCommand> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.MachineRunCommand::class == javaResource::class

    override fun map(javaResource: Resource): MachineRunCommand = MachineRunCommand(
        javaResource as
            com.pulumi.azurenative.hybridcompute.MachineRunCommand,
    )
}

/**
 * @see [MachineRunCommand].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineRunCommand].
 */
public suspend fun machineRunCommand(
    name: String,
    block: suspend MachineRunCommandResourceBuilder.() -> Unit,
): MachineRunCommand {
    val builder = MachineRunCommandResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineRunCommand].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineRunCommand(name: String): MachineRunCommand {
    val builder = MachineRunCommandResourceBuilder()
    builder.name(name)
    return builder.build()
}
