@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the Gateway.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGatewayPlainArgs(
    public val gatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetGatewayPlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetGatewayPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Gateway.
     */
    @JvmName("vaehwowtiibgjdof")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("luippyqrrxgdmpry")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGatewayPlainArgs = GetGatewayPlainArgs(
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
