@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetLicensePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property licenseName The name of the license.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLicensePlainArgs(
    public val licenseName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetLicensePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetLicensePlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetLicensePlainArgs.builder()
            .licenseName(licenseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLicensePlainArgs].
 */
@PulumiTagMarker
public class GetLicensePlainArgsBuilder internal constructor() {
    private var licenseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the license.
     */
    @JvmName("ymfktpgxqicdtsja")
    public suspend fun licenseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.licenseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dldwnfakkkwxsste")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLicensePlainArgs = GetLicensePlainArgs(
        licenseName = licenseName ?: throw PulumiNullFieldException("licenseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
