@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property machineName The name of the hybrid machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMachinePlainArgs(
    public val expand: String? = null,
    public val machineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetMachinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetMachinePlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetMachinePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachinePlainArgs].
 */
@PulumiTagMarker
public class GetMachinePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var machineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("pejbcouolusceiye")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("pqgendhdmfttrbcj")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mxchcmrlfrqcfcqm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMachinePlainArgs = GetMachinePlainArgs(
        expand = expand,
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
