@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.LocationDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metadata pertaining to the geographic location of the resource.
 * @property city The city or locality where the resource is located.
 * @property countryOrRegion The country or region where the resource is located
 * @property district The district, state, or province where the resource is located.
 * @property name A canonical name for the geographic or physical location.
 */
public data class LocationDataArgs(
    public val city: Output<String>? = null,
    public val countryOrRegion: Output<String>? = null,
    public val district: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.LocationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.LocationDataArgs =
        com.pulumi.azurenative.hybridcompute.inputs.LocationDataArgs.builder()
            .city(city?.applyValue({ args0 -> args0 }))
            .countryOrRegion(countryOrRegion?.applyValue({ args0 -> args0 }))
            .district(district?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationDataArgs].
 */
@PulumiTagMarker
public class LocationDataArgsBuilder internal constructor() {
    private var city: Output<String>? = null

    private var countryOrRegion: Output<String>? = null

    private var district: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The city or locality where the resource is located.
     */
    @JvmName("oqxvxyswovmmqnca")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The country or region where the resource is located
     */
    @JvmName("flqcirhhladhhbjh")
    public suspend fun countryOrRegion(`value`: Output<String>) {
        this.countryOrRegion = value
    }

    /**
     * @param value The district, state, or province where the resource is located.
     */
    @JvmName("jwvwmmikaidbwoqv")
    public suspend fun district(`value`: Output<String>) {
        this.district = value
    }

    /**
     * @param value A canonical name for the geographic or physical location.
     */
    @JvmName("jllpkrambtdeuktu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The city or locality where the resource is located.
     */
    @JvmName("cbbwqjuoyjdtglsp")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The country or region where the resource is located
     */
    @JvmName("ysvrdrlbltgibipx")
    public suspend fun countryOrRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryOrRegion = mapped
    }

    /**
     * @param value The district, state, or province where the resource is located.
     */
    @JvmName("xuwxdpaengvfrvsg")
    public suspend fun district(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.district = mapped
    }

    /**
     * @param value A canonical name for the geographic or physical location.
     */
    @JvmName("gdmbctwifdjvtffu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LocationDataArgs = LocationDataArgs(
        city = city,
        countryOrRegion = countryOrRegion,
        district = district,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
