@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.MachineExtensionInstanceViewArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the Machine Extension Instance View.
 * @property name The machine extension name.
 * @property status Instance view status.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class MachineExtensionInstanceViewArgs(
    public val name: Output<String>? = null,
    public val status: Output<MachineExtensionInstanceViewStatusArgs>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.MachineExtensionInstanceViewArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.MachineExtensionInstanceViewArgs =
        com.pulumi.azurenative.hybridcompute.inputs.MachineExtensionInstanceViewArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineExtensionInstanceViewArgs].
 */
@PulumiTagMarker
public class MachineExtensionInstanceViewArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var status: Output<MachineExtensionInstanceViewStatusArgs>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value The machine extension name.
     */
    @JvmName("klmljmlqgtmhwlpb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Instance view status.
     */
    @JvmName("ipqmswsrycjxbmof")
    public suspend fun status(`value`: Output<MachineExtensionInstanceViewStatusArgs>) {
        this.status = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("lyfauwkhtqifgwoh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("hlospxoeuaxkonxk")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The machine extension name.
     */
    @JvmName("cgjwkbcebmbscham")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Instance view status.
     */
    @JvmName("vjekugkgkrwujpjt")
    public suspend fun status(`value`: MachineExtensionInstanceViewStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument Instance view status.
     */
    @JvmName("aodbffiyypmwdpyc")
    public suspend fun status(argument: suspend MachineExtensionInstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = MachineExtensionInstanceViewStatusArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("bdjnnwnswnteyole")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("kadflqfbprkvyboq")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): MachineExtensionInstanceViewArgs = MachineExtensionInstanceViewArgs(
        name = name,
        status = status,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
