@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.OSProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the operating system settings for the hybrid machine.
 * @property linuxConfiguration Specifies the linux configuration for update management.
 * @property windowsConfiguration Specifies the windows configuration for update management.
 */
public data class OSProfileArgs(
    public val linuxConfiguration: Output<OSProfileLinuxConfigurationArgs>? = null,
    public val windowsConfiguration: Output<OSProfileWindowsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.OSProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.OSProfileArgs =
        com.pulumi.azurenative.hybridcompute.inputs.OSProfileArgs.builder()
            .linuxConfiguration(
                linuxConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OSProfileArgs].
 */
@PulumiTagMarker
public class OSProfileArgsBuilder internal constructor() {
    private var linuxConfiguration: Output<OSProfileLinuxConfigurationArgs>? = null

    private var windowsConfiguration: Output<OSProfileWindowsConfigurationArgs>? = null

    /**
     * @param value Specifies the linux configuration for update management.
     */
    @JvmName("xnjsrryrplbarumb")
    public suspend fun linuxConfiguration(`value`: Output<OSProfileLinuxConfigurationArgs>) {
        this.linuxConfiguration = value
    }

    /**
     * @param value Specifies the windows configuration for update management.
     */
    @JvmName("ahdyfvofmmjcecra")
    public suspend fun windowsConfiguration(`value`: Output<OSProfileWindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value Specifies the linux configuration for update management.
     */
    @JvmName("rqeaotntgmbuusko")
    public suspend fun linuxConfiguration(`value`: OSProfileLinuxConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxConfiguration = mapped
    }

    /**
     * @param argument Specifies the linux configuration for update management.
     */
    @JvmName("beijmoimkwimxbke")
    public suspend fun linuxConfiguration(argument: suspend OSProfileLinuxConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileLinuxConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxConfiguration = mapped
    }

    /**
     * @param value Specifies the windows configuration for update management.
     */
    @JvmName("bpeigtmqjhtyjpkc")
    public suspend fun windowsConfiguration(`value`: OSProfileWindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument Specifies the windows configuration for update management.
     */
    @JvmName("epstdrdkbmgoidyh")
    public suspend fun windowsConfiguration(argument: suspend OSProfileWindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileWindowsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): OSProfileArgs = OSProfileArgs(
        linuxConfiguration = linuxConfiguration,
        windowsConfiguration = windowsConfiguration,
    )
}
