@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.OSProfileWindowsConfigurationArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.AssessmentModeTypes
import com.pulumi.azurenative.hybridcompute.kotlin.enums.PatchModeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the windows configuration for update management.
 * @property assessmentMode Specifies the assessment mode.
 * @property patchMode Specifies the patch mode.
 */
public data class OSProfileWindowsConfigurationArgs(
    public val assessmentMode: Output<Either<String, AssessmentModeTypes>>? = null,
    public val patchMode: Output<Either<String, PatchModeTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.OSProfileWindowsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.OSProfileWindowsConfigurationArgs =
        com.pulumi.azurenative.hybridcompute.inputs.OSProfileWindowsConfigurationArgs.builder()
            .assessmentMode(
                assessmentMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .patchMode(
                patchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OSProfileWindowsConfigurationArgs].
 */
@PulumiTagMarker
public class OSProfileWindowsConfigurationArgsBuilder internal constructor() {
    private var assessmentMode: Output<Either<String, AssessmentModeTypes>>? = null

    private var patchMode: Output<Either<String, PatchModeTypes>>? = null

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("yuerbwsqldxukwvo")
    public suspend fun assessmentMode(`value`: Output<Either<String, AssessmentModeTypes>>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("ogmmoterncumacyj")
    public suspend fun patchMode(`value`: Output<Either<String, PatchModeTypes>>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("uyeeykuxqsmlbvxa")
    public suspend fun assessmentMode(`value`: Either<String, AssessmentModeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("nqyxjwbdtfehumwj")
    public fun assessmentMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("imnaocilysoxqfxb")
    public fun assessmentMode(`value`: AssessmentModeTypes) {
        val toBeMapped = Either.ofRight<String, AssessmentModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("rxkotcohqptlrmsp")
    public suspend fun patchMode(`value`: Either<String, PatchModeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("hqstjxvavhbsdgfj")
    public fun patchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PatchModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("txbnarujfnbmekya")
    public fun patchMode(`value`: PatchModeTypes) {
        val toBeMapped = Either.ofRight<String, PatchModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): OSProfileWindowsConfigurationArgs = OSProfileWindowsConfigurationArgs(
        assessmentMode = assessmentMode,
        patchMode = patchMode,
    )
}
