@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Private endpoint which the connection belongs to.
 * @property id Resource id of the private endpoint.
 */
public data class PrivateEndpointPropertyArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointPropertyArgs =
        com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointPropertyArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointPropertyArgs].
 */
@PulumiTagMarker
public class PrivateEndpointPropertyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource id of the private endpoint.
     */
    @JvmName("rcjwrathjyfbixuh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource id of the private endpoint.
     */
    @JvmName("fpwkpglgakeingea")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PrivateEndpointPropertyArgs = PrivateEndpointPropertyArgs(
        id = id,
    )
}
