@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes properties that can identify extensions.
 * @property publisher Publisher of the extension.
 * @property type Type of the extension.
 */
public data class ConfigurationExtensionResponse(
    public val publisher: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.ConfigurationExtensionResponse): ConfigurationExtensionResponse = ConfigurationExtensionResponse(
            publisher = javaType.publisher(),
            type = javaType.type(),
        )
    }
}
