@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ESU key
 * @property licenseStatus The current status of the license profile key.
 * @property sku SKU number.
 */
public data class EsuKeyResponse(
    public val licenseStatus: String? = null,
    public val sku: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.EsuKeyResponse): EsuKeyResponse = EsuKeyResponse(
            licenseStatus = javaType.licenseStatus().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
        )
    }
}
