@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes an Arc Gateway.
 * @property allowedFeatures Specifies the list of features that are enabled for this Gateway.
 * @property gatewayEndpoint The endpoint fqdn for the Gateway.
 * @property gatewayId A unique, immutable, identifier for the Gateway.
 * @property gatewayType The type of the Gateway resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGatewayResult(
    public val allowedFeatures: List<String>? = null,
    public val gatewayEndpoint: String,
    public val gatewayId: String,
    public val gatewayType: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.GetGatewayResult): GetGatewayResult = GetGatewayResult(
            allowedFeatures = javaType.allowedFeatures().map({ args0 -> args0 }),
            gatewayEndpoint = javaType.gatewayEndpoint(),
            gatewayId = javaType.gatewayId(),
            gatewayType = javaType.gatewayType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
